(*| 13:55 14/11/1990 *)
UNIT TV;

INTERFACE

USES Vars,ScrnDrv;

TYPE
  TVLineData = ARRAY[1..MaxTVCol] OF CHAR;
  TVLineColour = ARRAY[1..MaxTVCol] OF BYTE;
  TVScreen = OBJECT
               Data  : ARRAY[1..MaxTVRow] OF TVLineData;
               Colour: ARRAY[1..MaxTVRow] OF TVLineColour;
               PROCEDURE Init(D:CHAR; C:BYTE);
               PROCEDURE Write(Col,Row,StrCol: BYTE; Str:String);
               PROCEDURE Done;
             END;
  TVWindow = OBJECT(TVScreen)
               Col1,Row1: Integer;
               Saved: SavedWindowType;
               PROCEDURE Init(D:CHAR; C,ColSet,RowSet:BYTE);
               PROCEDURE SetXY(ColSet,RowSet:BYTE);
               PROCEDURE Show;
               PROCEDURE Hide;
               PROCEDURE Done;
             END;

IMPLEMENTATION

USES Crt,BWFW;

PROCEDURE TVScreen.Init(D:CHAR; C:BYTE);
VAR
  Row,Col: INTEGER;
BEGIN
  FOR Col:=1 TO MaxTVCol DO
    FOR Row:=1 TO MaxTVRow DO BEGIN
      Data[Row,Col]:=D;
      Colour[Row,Col]:=C;
    END;
END;  { TVScreen.Init }

PROCEDURE TVScreen.Write(Col,Row,StrCol: BYTE; Str:String);
VAR
  I: INTEGER;
BEGIN
  FOR I:=1 TO Length(Str) DO BEGIN
    Data[Row,Col+I-1]:=Str[I];
    Colour[Row,Col+I-1]:=StrCol;
  END;
END;  { TVScreen.Write }

PROCEDURE TVScreen.Done;
BEGIN
END;  { TVScreen.Done }

PROCEDURE TVWindow.Init(D:CHAR; C,ColSet,RowSet:BYTE);
BEGIN
  TVScreen.Init(D,C);
  Col1:=ColSet;
  Row1:=RowSet;
END;  { TVWindow.Init }

PROCEDURE TVWindow.SetXY(ColSet,RowSet:BYTE);
BEGIN
  Col1:=ColSet;
  Row1:=RowSet;
END;  { TVWindow.SetXY }

PROCEDURE TVWindow.Show;
VAR
  Row,Col: INTEGER;
  ThisRow: STRING[MaxTVCol];
BEGIN
  MakeWindow(Col1-1,Row1-1,MaxTVCol+2,MaxTVRow+2);
  Saved:=WArray;
  FOR Row:=1 TO MaxTVRow DO BEGIN
(*
    SetMemAddress(Col1,Row1+Row-1);
    FastWrite(Data[Row],Colour[Row],Mem[ScreenBase:ScrnAddr],MaxTVCol,0);
*)
    FastWriteXY(Data[Row],Colour[Row],Col1,Row1+Row-1,MaxTVCol,0);
  END;
END;  { TVWindow.Show }

PROCEDURE TVWindow.Hide;
BEGIN
  WArray:=Saved;
  UnMakeWindow(Col1-1,Row1-1,MaxTVCol+2,MaxTVRow+2);
END;  { TVWindow.Hide }

PROCEDURE TVWindow.Done;
BEGIN
END;  { TVWindow.Done }

END.

